// config: norepeat

#include "GetObjects.js"
#include "GetLine.js"
#include "GetPoint.js"

function DoOrientLineToLine()
{
	var objectpicker = moi.ui.createObjectPicker();
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'BasePrompt1' );
	moi.ui.showUI( 'OrientOptions' );
	moi.ui.endUIUpdate();
	
	var basepoints = new Array();
	if ( !GetLine( basepoints, 'BasePrompt1', 'BasePrompt2' ) )
		return;
		
	var factory = moi.command.createFactory( 'orientlinetoline' );
	factory.setInput( 0, objects );
		
	while ( 1 )
	{
		moi.ui.clearPickedPoints();
			
		moi.ui.beginUIUpdate();
		moi.ui.hideUI( 'BasePrompt2' );
		moi.ui.hideUI( 'TargetPrompt2' );
		moi.ui.showUI( 'TargetPrompt1' );
		moi.ui.endUIUpdate();
			
		var pointpicker = moi.ui.createPointPicker();
		if ( !GetPoint( pointpicker ) )
			return;
		
		moi.ui.beginUIUpdate();
		moi.ui.hideUI( 'TargetPrompt1' );
		moi.ui.showUI( 'TargetPrompt2' );
		moi.ui.endUIUpdate();

		moi.ui.bindUIToInput( 'Scaling', 'value', factory.getInput(6) );
		factory.setInput( 1, basepoints[0] );
		factory.setInput( 2, basepoints[1] );
		factory.setInput( 3, pointpicker.pt );
		pointpicker.bindResultPt( factory.getInput(4) );

		if ( !GetPoint( pointpicker ) )
			return;
			
		// Enable dropping a copy if the checkbox is set or if Ctrl was held down.
		var makecopies = moi.ui.commandUI.MakeCopies.value || pointpicker.controlDown;
		
		// If not making copies, then finish now.	
		if ( !makecopies )
		{
			factory.commit();
			break;
		}
		
		// Otherwise, drop a copy and keep going.

		// Set up a new factory for the next one.
		var newfactory = moi.command.createFactory( 'orientlinetoline' );
		newfactory.setInput( 0, objects );
			
		// Set the make copies option on the current factory.
		factory.setInput( 5, true );
		
		factory.commitAndPrepOther( newfactory );
		
		factory = newfactory;
	}
}

DoOrientLineToLine();
